<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Painel RPG Medieval</title>
  <style>
    :root {
      --primary: #007bff;
      --dark-bg: #0b0b0b;
      --light-text: #ffffff;
      --border-color: #007bff;
      --card-bg: #1a1a1a;
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: var(--dark-bg);
      color: var(--light-text);
      overflow-x: hidden;
    }

    .container {
      width: 100%;
      max-width: 1200px;
      margin: auto;
      padding: 20px;
      position: relative;
      z-index: 1;
    }

    .light-rays {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      background: radial-gradient(circle at 30% 30%, rgba(0, 123, 255, 0.05), transparent 40%),
                  radial-gradient(circle at 70% 70%, rgba(0, 123, 255, 0.05), transparent 40%);
      animation: lightmove 6s linear infinite;
      z-index: 0;
    }

    @keyframes lightmove {
      0% {
        background-position: 30% 30%, 70% 70%;
      }
      50% {
        background-position: 40% 20%, 60% 80%;
      }
      100% {
        background-position: 30% 30%, 70% 70%;
      }
    }

    .banner {
      background: linear-gradient(145deg, #000000, #1a1a1a);
      color: var(--light-text);
      text-align: center;
      padding: 40px;
      margin-bottom: 20px;
      border: 2px solid var(--border-color);
      border-radius: 12px;
      font-size: 1.5rem;
    }

    .row {
      display: flex;
      gap: 15px;
      margin-bottom: 15px;
      flex-wrap: wrap;
      justify-content: center;
      text-align: center;
    }

    .col {
      background-color: var(--card-bg);
      border: 1px solid var(--border-color);
      padding: 15px;
      border-radius: 10px;
      flex: 1;
      min-width: 250px;
    }

    .sidebar {
      flex: 1;
      min-width: 220px;
    }

    .main {
      flex: 2;
      min-width: 400px;
    }

    .btn-group button {
      display: block;
      width: 100%;
      margin-bottom: 8px;
      padding: 10px;
      background-color: transparent;
      color: var(--light-text);
      border: 2px solid var(--primary);
      border-radius: 6px;
      cursor: pointer;
      font-weight: bold;
      transition: all 0.3s ease-in-out;
    }

    .btn-group button:hover {
      background-color: var(--primary);
      color: #000;
    }

    .info-box {
      height: 100px;
      background-color: #2a2a2a;
      padding: 10px;
      border-radius: 10px;
      border: 1px solid var(--border-color);
    }

    footer {
      background-color: #000000;
      color: var(--light-text);
      text-align: center;
      padding: 15px;
      margin-top: 30px;
      border-top: 2px solid var(--primary);
    }
  </style>
</head>
<body>
  <div class="light-rays"></div>
  <div class="container">
    <div class="banner">Banner bn.png</div>

    <div class="row">
      <div class="col sidebar">
        <p><strong>Dados do jogador</strong><br>
        Nome<br>
        wallet<br>
        Carteira<br>
        Saldo em dinheiro<br>
        Fichas<br>
        Personagens</p>
      </div>
      <div class="col main">
        <p><strong>Sistema de notícias com fotos, com scroll</strong><br>
        Deve puxar as notícias na tabela noticias<br>
        filtrando a data mais recente<br>
        mostrar a notícia e a imagem, depois outra, se não tiver uma imagem, arrume uma imagem padrão na internet, com um cenário de natureza medieval, cada notícia deve mostrar o título, notícia e data.</p>
      </div>
      <div class="col sidebar">
        <div class="btn-group">
          <button>fale conosco</button>
          <button>notificações</button>
          <button>adm personagem</button>
          <button>jogo</button>
          <button>Mercado</button>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col">
        <p><strong>Lista das ordens de comprae</strong><br>
        ordenada pelo maior valor<br>
        Ao clicar vai pra página ordensdevenda.php</p>
      </div>
      <div class="col">
        <p><strong>mostrar o graficoo.php</strong></p>
      </div>
      <div class="col">
        <p><strong>Lista das ordens de venda</strong><br>
        Ao clicar vai pra página ordensdevenda.php<br>
        ordenada pelo menor valor</p>
      </div>
    </div>

    <div class="row">
      <div class="col info-box">quadro de informação</div>
      <div class="col">
        <div class="btn-group">
          <button>Analisar melhor o gráfico</button>
          <button>Nosso projeto</button>
          <button>Livro NFT's</button>
          <button>Sair</button>
        </div>
      </div>
      <div class="col info-box">quadro de informação</div>
    </div>

    <footer>rodape</footer>
  </div>
</body>
</html>
